/*
 * Decompiled with CFR 0.152.
 */
package craftwp.packets;

import craftwp.CraftableWP;
import craftwp.ItemWaypointWand;
import craftwp.PlayerWaypoints;
import craftwp.ServerWaypoint;
import craftwp.packets.CreatePacketServerSide;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class ProcessPacketServerSide {
    public static void processPacketOnServer(ByteBuf buf, Side side, EntityPlayerMP player) {
        if (side == Side.SERVER) {
            try {
                ByteBufInputStream bbis = new ByteBufInputStream(buf);
                int packetTypeID = 0;
                try {
                    packetTypeID = bbis.readInt();
                }
                catch (Exception e) {
                    bbis.close();
                    return;
                }
                if (packetTypeID < 1) {
                    bbis.close();
                    return;
                }
                switch (packetTypeID) {
                    case 4: {
                        byte category = bbis.readByte();
                        int id = bbis.readInt();
                        String cat = null;
                        if (category == 1) {
                            cat = player.func_70005_c_();
                        }
                        World world = player.func_130014_f_();
                        String folder = world.field_73011_w.getSaveFolder();
                        PlayerWaypoints pw = CraftableWP.serverWaypoints.get(cat);
                        ServerWaypoint waypoint = (ServerWaypoint)((ArrayList)pw.get(folder)).get(id);
                        if (!waypoint.freeTeleport && waypoint.getTeleportAmount() == 0) break;
                        if (!waypoint.freeTeleport) {
                            waypoint.decrementTeleportation();
                        }
                        pw.setSaveNeeded(world.field_73011_w.getSaveFolder(), true);
                        double bX = player.field_70165_t;
                        double bY = player.field_70163_u;
                        double bZ = player.field_70161_v;
                        ItemWaypointWand.teleportToWaypoint(waypoint, (Entity)player, world);
                        CreatePacketServerSide.sendTeleportPacketToClient(world, cat, id, player);
                        CreatePacketServerSide.sendParticlesPacketToAllWithin256(world, bX, bY, bZ, waypoint.x, waypoint.y, waypoint.z, player.field_70130_N, player.field_70131_O, waypoint);
                    }
                }
                bbis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

