/*
 * Decompiled with CFR 0.152.
 */
package craftwp.packets;

import craftwp.ClientEvents;
import craftwp.CraftableWP;
import craftwp.ItemWaypointWand;
import craftwp.Waypoint;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProcessPacketClientSide {
    @SideOnly(value=Side.CLIENT)
    public static void processPacketOnClient(ByteBuf parBB, Side parSide) throws IOException {
        if (parSide == Side.CLIENT) {
            ByteBufInputStream bbis = new ByteBufInputStream(parBB);
            try {
                int packetTypeID = bbis.readInt();
                switch (packetTypeID) {
                    case 1: {
                        CraftableWP.waypoints.get(0).clear();
                        CraftableWP.waypoints.get(1).clear();
                        break;
                    }
                    case 2: {
                        if (bbis.available() == 0) break;
                        int x = bbis.readInt();
                        int y = bbis.readInt();
                        int z = bbis.readInt();
                        int nameL = bbis.readInt();
                        String name = ProcessPacketClientSide.readString(bbis, nameL);
                        int symbolL = bbis.readInt();
                        String symbol = ProcessPacketClientSide.readString(bbis, symbolL);
                        int color = bbis.readInt();
                        byte category = bbis.readByte();
                        ArrayList<Waypoint> wps = CraftableWP.waypoints.get(category);
                        Waypoint wp = new Waypoint(category, x, y, z, name, symbol, color);
                        wp.updateBeamHeight((World)Minecraft.func_71410_x().field_71441_e);
                        wps.add(wp);
                        break;
                    }
                    case 3: {
                        byte category = bbis.readByte();
                        int index = bbis.readInt();
                        if (index < 0) break;
                        CraftableWP.waypoints.get(category).remove(index);
                        break;
                    }
                    case 4: {
                        byte category = bbis.readByte();
                        int index = bbis.readInt();
                        ItemWaypointWand.teleportToWaypoint(CraftableWP.waypoints.get(category).get(index), (Entity)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71439_g.func_130014_f_());
                        break;
                    }
                    case 5: {
                        double bX = bbis.readDouble();
                        double bY = bbis.readDouble();
                        double bZ = bbis.readDouble();
                        int x = bbis.readInt();
                        int y = bbis.readInt();
                        int z = bbis.readInt();
                        float width = bbis.readFloat();
                        float height = bbis.readFloat();
                        ClientEvents.teleportSound = new BlockPos(x, y, z);
                        ItemWaypointWand.spawnTeleportParticles(bX, bY, bZ, (double)x + 0.5, y, (double)z + 0.5, width, height, (World)Minecraft.func_71410_x().field_71441_e);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            bbis.close();
        }
    }

    public static String readString(ByteBufInputStream bbis, int len) throws IOException {
        byte[] bytes = new byte[len];
        bbis.read(bytes, 0, len);
        return new String(bytes);
    }
}

