/*
 * Decompiled with CFR 0.152.
 */
package craftwp.packets;

import craftwp.CraftableWP;
import craftwp.ServerWaypoint;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class CreatePacketServerSide {
    public static FMLProxyPacket createClearWaypointsPacket() throws IOException {
        ByteBufOutputStream bbos = new ByteBufOutputStream(Unpooled.buffer());
        bbos.writeInt(1);
        FMLProxyPacket packet = new FMLProxyPacket(new PacketBuffer(bbos.buffer()), CraftableWP.packetChannel);
        bbos.close();
        return packet;
    }

    public static FMLProxyPacket createAddWaypointPacket(ServerWaypoint w) throws IOException {
        ByteBufOutputStream bbos = new ByteBufOutputStream(Unpooled.buffer());
        bbos.writeInt(2);
        bbos.writeInt(w.x);
        bbos.writeInt(w.y);
        bbos.writeInt(w.z);
        bbos.writeInt(w.name.length());
        bbos.writeBytes(w.name);
        bbos.writeInt(w.symbol.length());
        bbos.writeBytes(w.symbol);
        bbos.writeInt(w.color);
        bbos.writeByte(w.owner == null ? 0 : 1);
        FMLProxyPacket packet = new FMLProxyPacket(new PacketBuffer(bbos.buffer()), CraftableWP.packetChannel);
        bbos.close();
        return packet;
    }

    public static FMLProxyPacket createRemoveWaypointPacket(byte category, int index) throws IOException {
        ByteBufOutputStream bbos = new ByteBufOutputStream(Unpooled.buffer());
        bbos.writeInt(3);
        bbos.writeByte((int)category);
        bbos.writeInt(index);
        FMLProxyPacket packet = new FMLProxyPacket(new PacketBuffer(bbos.buffer()), CraftableWP.packetChannel);
        bbos.close();
        return packet;
    }

    public static FMLProxyPacket createTeleportPacket(byte category, int index) throws IOException {
        ByteBufOutputStream bbos = new ByteBufOutputStream(Unpooled.buffer());
        bbos.writeInt(4);
        bbos.writeByte((int)category);
        bbos.writeInt(index);
        FMLProxyPacket packet = new FMLProxyPacket(new PacketBuffer(bbos.buffer()), CraftableWP.packetChannel);
        bbos.close();
        return packet;
    }

    public static FMLProxyPacket createParticlesPacket(double bX, double bY, double bZ, float width, float height, int x, int y, int z) throws IOException {
        ByteBufOutputStream bbos = new ByteBufOutputStream(Unpooled.buffer());
        bbos.writeInt(5);
        bbos.writeDouble(bX);
        bbos.writeDouble(bY);
        bbos.writeDouble(bZ);
        bbos.writeInt(x);
        bbos.writeInt(y);
        bbos.writeInt(z);
        bbos.writeFloat(width);
        bbos.writeFloat(height);
        FMLProxyPacket packet = new FMLProxyPacket(new PacketBuffer(bbos.buffer()), CraftableWP.packetChannel);
        bbos.close();
        return packet;
    }

    public static void sendToAll(FMLProxyPacket parPacket) {
        CraftableWP.channel.sendToAll(parPacket);
    }

    public static void sendTo(FMLProxyPacket parPacket, EntityPlayerMP player) {
        CraftableWP.channel.sendTo(parPacket, player);
    }

    public static void sendClearPacketToClient(EntityPlayerMP player) {
        try {
            CreatePacketServerSide.sendTo(CreatePacketServerSide.createClearWaypointsPacket(), player);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendAddPacketToClient(ServerWaypoint w, EntityPlayerMP player) {
        try {
            if (w.owner == null || player.func_70005_c_().equals(w.owner)) {
                CreatePacketServerSide.sendTo(CreatePacketServerSide.createAddWaypointPacket(w), player);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendTeleportPacketToClient(World w, String category, int index, EntityPlayerMP p) {
        try {
            if (category == null || p.func_70005_c_().equals(category)) {
                CreatePacketServerSide.sendTo(CreatePacketServerSide.createTeleportPacket((byte)(category != null ? 1 : 0), index), p);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendAddPacketToAll(World w, ServerWaypoint wp) {
        for (Object o : w.field_73010_i) {
            CreatePacketServerSide.sendAddPacketToClient(wp, (EntityPlayerMP)o);
        }
    }

    public static void sendRemovePacketToAll(World w, String category, int index) {
        try {
            for (Object o : w.field_73010_i) {
                EntityPlayerMP p = (EntityPlayerMP)o;
                if (category != null && !p.func_70005_c_().equals(category)) continue;
                CreatePacketServerSide.sendTo(CreatePacketServerSide.createRemoveWaypointPacket((byte)(category != null ? 1 : 0), index), p);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendParticlesPacketToAllWithin256(World w, double bX, double bY, double bZ, int x, int y, int z, float width, float height, ServerWaypoint waypoint) {
        try {
            for (Object o : w.field_73010_i) {
                boolean spot2;
                EntityPlayerMP p = (EntityPlayerMP)o;
                boolean spot1 = Math.abs(p.field_70165_t - bX) < 256.0 && Math.abs(p.field_70161_v - bZ) < 256.0 && Math.abs(p.field_70163_u - bY) < 256.0;
                boolean bl = spot2 = Math.abs(p.field_70165_t - (double)x) < 256.0 && Math.abs(p.field_70161_v - (double)z) < 256.0 && Math.abs(p.field_70163_u - (double)y) < 25.0;
                if (spot1 && spot2) {
                    CreatePacketServerSide.sendTo(CreatePacketServerSide.createParticlesPacket(bX, bY, bZ, width, height, x, y, z), p);
                    continue;
                }
                if (spot1) {
                    CreatePacketServerSide.sendTo(CreatePacketServerSide.createParticlesPacket(bX, bY, bZ, width, height, (int)Math.floor(bX), (int)Math.floor(bY), (int)Math.floor(bZ)), p);
                    continue;
                }
                if (!spot2) continue;
                CreatePacketServerSide.sendTo(CreatePacketServerSide.createParticlesPacket(x, y, z, width, height, x, y, z), p);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

