/*
 * Decompiled with CFR 0.152.
 */
package craftwp;

import craftwp.ClientEvents;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemDye;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class Waypoint {
    private static ResourceLocation beamBottom = new ResourceLocation("xaerocraftwp", "textures/beambottom.png");
    public int category;
    public int x;
    public int y;
    public int z;
    public String name;
    public String symbol;
    public int color;
    public double teleportScale = 1.0;
    public boolean teleportScaleUp = true;
    public int beamHeight = 256;
    public boolean justPlaced = true;

    public Waypoint(int category, int x, int y, int z, String name, String symbol, int color) {
        this.category = category;
        this.x = x;
        this.y = y;
        this.z = z;
        this.symbol = symbol;
        this.color = color;
        this.name = name;
    }

    public double getDistanceSq(double x, double y, double z) {
        double d3 = (double)this.x - x;
        double d4 = (double)this.y - y;
        double d5 = (double)this.z - z;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public String getName() {
        return I18n.func_135052_a((String)this.name, (Object[])new Object[0]);
    }

    public void drawIconInWorld(VertexBuffer vertexBuffer, Tessellator tessellator, FontRenderer fontrenderer, String text, float textSize, boolean background, boolean showDistance) {
        int c = ItemDye.field_150922_c[this.color];
        float l = (float)(c >> 16 & 0xFF) / 255.0f;
        float i1 = (float)(c >> 8 & 0xFF) / 255.0f;
        float j1 = (float)(c & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        int s = fontrenderer.func_78256_a(this.symbol) / 2;
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        GlStateManager.func_179131_c((float)l, (float)i1, (float)j1, (float)0.47058824f);
        vertexBuffer.func_181662_b(-5.0, -9.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(-5.0, 0.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(4.0, 0.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(4.0, -9.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        fontrenderer.func_78276_b(this.symbol, -s, -8, 0x20FFFFFF);
        fontrenderer.func_78276_b(this.symbol, -s, -8, -1);
        if (ClientEvents.mc.func_152349_b()) {
            textSize *= 1.5f;
        }
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(textSize / 2.0f), (float)(textSize / 2.0f), (float)1.0f);
        int t = fontrenderer.func_78256_a(text) / 2;
        if (background) {
            GlStateManager.func_179090_x();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.27450982f);
            vertexBuffer.func_181662_b((double)(-t) - 1.0, 0.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(-t) - 1.0, 9.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)t, 9.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)t, 0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
        }
        fontrenderer.func_78276_b(text, -t, 1, 0x20FFFFFF);
        fontrenderer.func_78276_b(text, -t, 1, -1);
    }

    public void drawBeamInWorld(VertexBuffer vertexBuffer, Tessellator tessellator, double distance, int pos) {
        int minAlpha;
        boolean above;
        boolean below = pos < 0;
        boolean bl = above = pos > 0;
        if (pos == 0 && distance <= 0.5) {
            return;
        }
        int bottomAlpha = minAlpha = 40;
        if (distance > 5.0) {
            bottomAlpha = minAlpha + (int)((distance - 5.0) / 80.0 * (255.0 - (double)minAlpha));
        }
        if (bottomAlpha > 255) {
            bottomAlpha = 255;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7425);
        if (below) {
            this.beamBottom(vertexBuffer, tessellator, 0.0, bottomAlpha, below);
        }
        if (above) {
            this.beamTop(vertexBuffer, tessellator, 0.0, minAlpha, above);
        }
        GlStateManager.func_179090_x();
        this.beamStar(vertexBuffer, tessellator, distance, bottomAlpha);
        this.beam(vertexBuffer, tessellator, (double)this.beamHeight * 37.49, bottomAlpha, minAlpha);
        if (!below) {
            this.beamBottom(vertexBuffer, tessellator, 0.0, bottomAlpha, below);
        }
        if (!above) {
            this.beamTop(vertexBuffer, tessellator, 0.0, minAlpha, above);
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7424);
    }

    public void beamStar(VertexBuffer vertexBuffer, Tessellator tessellator, double distance, int bottomAlpha) {
        if (ClientEvents.mc.field_71474_y.field_74320_O != 0) {
            return;
        }
        GlStateManager.func_179094_E();
        if (distance < 5.0) {
            int i;
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            for (i = 0; i < 5; ++i) {
                GlStateManager.func_179114_b((float)-15.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.rightHalfBeam(vertexBuffer, tessellator, 37.49 * (double)this.beamHeight, bottomAlpha, bottomAlpha);
            }
            GlStateManager.func_179114_b((float)-105.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            for (i = 0; i < 5; ++i) {
                GlStateManager.func_179114_b((float)15.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.leftHalfBeam(vertexBuffer, tessellator, 37.49 * (double)this.beamHeight, bottomAlpha, bottomAlpha);
            }
        }
        GlStateManager.func_179121_F();
    }

    public void beamTop(VertexBuffer vertexBuffer, Tessellator tessellator, double height, int bottomAlpha, boolean below) {
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.beamBottom(vertexBuffer, tessellator, (double)(-(this.beamHeight - 2)) * 37.49, bottomAlpha, below);
        GlStateManager.func_179114_b((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    public void beamBottom(VertexBuffer vertexBuffer, Tessellator tessellator, double height, int bottomAlpha, boolean otherSide) {
        if (ClientEvents.mc.field_71474_y.field_74320_O != 0) {
            return;
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)bottomAlpha / 255.0f));
        ClientEvents.mc.func_110434_K().func_110577_a(beamBottom);
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b(-18.75, 37.49 - height, -18.75).func_187315_a(0.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(18.75, 37.49 - height, -18.75).func_187315_a(1.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(18.75, 37.49 - height, 18.75).func_187315_a(1.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(-18.75, 37.49 - height, 18.75).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        if (otherSide) {
            for (int i = 0; i < 2; ++i) {
                if (i == 1) {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                vertexBuffer.func_181662_b(-18.75, 37.49 - height, -18.75).func_187315_a(0.0, 1.0).func_181675_d();
                vertexBuffer.func_181662_b(-18.75, 37.49 - height, 18.75).func_187315_a(0.0, 0.0).func_181675_d();
                vertexBuffer.func_181662_b(18.75, 37.49 - height, 18.75).func_187315_a(1.0, 0.0).func_181675_d();
                vertexBuffer.func_181662_b(18.75, 37.49 - height, -18.75).func_187315_a(1.0, 1.0).func_181675_d();
                tessellator.func_78381_a();
                if (i != 1) continue;
                GlStateManager.func_179114_b((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
    }

    public void leftHalfBeam(VertexBuffer vertexBuffer, Tessellator tessellator, double height, int bottomAlpha, int minAlpha) {
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_181662_b(-18.75, 37.49 - height, 0.0).func_181669_b(255, 255, 255, minAlpha).func_181675_d();
        vertexBuffer.func_181662_b(-18.75, 37.49, 0.0).func_181669_b(255, 255, 255, bottomAlpha).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 37.49, 0.0).func_181669_b(255, 255, 255, bottomAlpha).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 37.49 - height, 0.0).func_181669_b(255, 255, 255, minAlpha).func_181675_d();
        tessellator.func_78381_a();
    }

    public void rightHalfBeam(VertexBuffer vertexBuffer, Tessellator tessellator, double height, int bottomAlpha, int minAlpha) {
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_181662_b(0.0, 37.49 - height, 0.0).func_181669_b(255, 255, 255, minAlpha).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 37.49, 0.0).func_181669_b(255, 255, 255, bottomAlpha).func_181675_d();
        vertexBuffer.func_181662_b(18.75, 37.49, 0.0).func_181669_b(255, 255, 255, bottomAlpha).func_181675_d();
        vertexBuffer.func_181662_b(18.75, 37.49 - height, 0.0).func_181669_b(255, 255, 255, minAlpha).func_181675_d();
        tessellator.func_78381_a();
    }

    public void beam(VertexBuffer vertexBuffer, Tessellator tessellator, double height, int bottomAlpha, int minAlpha) {
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_181662_b(-18.75, 37.49 - height, 0.0).func_181669_b(255, 255, 255, minAlpha).func_181675_d();
        vertexBuffer.func_181662_b(-18.75, 37.49, 0.0).func_181669_b(255, 255, 255, bottomAlpha).func_181675_d();
        vertexBuffer.func_181662_b(18.75, 37.49, 0.0).func_181669_b(255, 255, 255, bottomAlpha).func_181675_d();
        vertexBuffer.func_181662_b(18.75, 37.49 - height, 0.0).func_181669_b(255, 255, 255, minAlpha).func_181675_d();
        tessellator.func_78381_a();
    }

    public void updateWaypoint(World world) {
    }

    public void updateBeamHeight(World world) {
        if (world == null) {
            return;
        }
        Chunk chunk = world.func_72964_e(this.x >> 4, this.z >> 4);
        if (chunk != null && chunk.func_177410_o()) {
            int insideX = this.x & 0xF;
            int insideZ = this.z & 0xF;
            int h = 1;
            while (this.y + h < 256) {
                IBlockState blockState = chunk.func_186032_a(insideX, this.y + h, insideZ);
                if (blockState != null && !(blockState.func_177230_c() instanceof BlockAir)) {
                    this.beamHeight = h;
                    return;
                }
                ++h;
            }
            this.beamHeight = 256;
        }
    }
}

