/*
 * Decompiled with CFR 0.152.
 */
package craftwp;

import craftwp.BlockWaypoint;
import craftwp.CraftableWP;
import craftwp.PlayerWaypoints;
import craftwp.TileWaypoint;
import craftwp.Waypoint;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnderPearl;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ServerWaypoint
extends Waypoint {
    public World world;
    public String owner;
    public boolean canBeDestroyed = true;
    public boolean freeTeleport = false;
    public ItemStack[] enderPearls = new ItemStack[9];

    public int getTeleportAmount() {
        int toReturn = 0;
        for (ItemStack i : this.enderPearls) {
            if (i == null || !(i.func_77973_b() instanceof ItemEnderPearl)) continue;
            toReturn += i.func_190916_E();
        }
        return toReturn;
    }

    public void setTeleportAmount(int amount) {
        int i = 0;
        while (amount > 0) {
            int slot = 0;
            slot = amount >= 16 ? 16 : amount;
            this.enderPearls[i] = new ItemStack(Items.field_151079_bi, slot);
            amount -= slot;
            ++i;
        }
    }

    public void decrementTeleportation() {
        for (int i = this.enderPearls.length - 1; i >= 0; --i) {
            if (this.enderPearls[i] == ItemStack.field_190927_a || this.enderPearls[i].func_190916_E() <= 0) continue;
            this.enderPearls[i].func_190917_f(-1);
            if (this.enderPearls[i].func_190916_E() != 0) break;
            this.enderPearls[i] = ItemStack.field_190927_a;
            break;
        }
    }

    public ServerWaypoint(String owner, int id, World w, int x, int y, int z, String name, String symbol, int color, boolean canBreak) {
        this(owner, w, x, y, z, name, symbol, color);
        this.canBeDestroyed = canBreak;
    }

    public ServerWaypoint(String owner, World w, int x, int y, int z, String name, String symbol, int color) {
        super(-1, x, y, z, name, symbol, color);
        this.owner = owner;
        this.world = w;
        for (int i = 0; i < this.enderPearls.length; ++i) {
            this.enderPearls[i] = ItemStack.field_190927_a;
        }
    }

    public void updateWaypoint() {
        BlockPos pos = new BlockPos(this.x, this.y, this.z);
        IBlockState state = this.world.func_180495_p(pos);
        if (state == null || state.func_177230_c() instanceof BlockWaypoint && ((TileWaypoint)this.world.func_175625_s((BlockPos)pos)).w == this) {
            return;
        }
        state = CraftableWP.waypointBlock.func_176223_P();
        this.world.func_175656_a(pos, state);
        ((TileWaypoint)this.world.func_175625_s((BlockPos)pos)).w = this;
    }

    public void saveWaypointSet() {
        String folder = this.world.field_73011_w.getSaveFolder();
        PlayerWaypoints pw = CraftableWP.serverWaypoints.get(this.owner);
        pw.setSaveNeeded(folder, true);
    }
}

