/*
 * Decompiled with CFR 0.152.
 */
package craftwp;

import craftwp.ClientEvents;
import craftwp.CraftableWP;
import craftwp.Waypoint;
import craftwp.packets.CreatePacketClientSide;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWaypointWand
extends Item {
    public ItemWaypointWand() {
        this.func_77625_d(64);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77655_b("wand");
        this.setRegistryName("xaerocraftwp:wand");
        this.func_77627_a(true);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return ClientEvents.mc.field_71439_g != null && ClientEvents.mc.field_71439_g.func_184587_cr() && (ClientEvents.mc.field_71439_g.func_184600_cs() == EnumHand.MAIN_HAND && ClientEvents.mc.field_71439_g.func_184582_a(EntityEquipmentSlot.MAINHAND) == stack || ClientEvents.mc.field_71439_g.func_184600_cs() == EnumHand.OFF_HAND && ClientEvents.mc.field_71439_g.func_184582_a(EntityEquipmentSlot.OFFHAND) == stack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return;
        }
        Waypoint closestWP = ItemWaypointWand.getPointingOrRandomWaypoint((Entity)entityLiving, 30.0f);
        if (closestWP == null) {
            return;
        }
        CreatePacketClientSide.sendTeleportationPacket(closestWP.category, CraftableWP.waypoints.get(closestWP.category).indexOf(closestWP));
    }

    public static void teleportToWaypoint(Waypoint wp, Entity player, World world) {
        player.func_70012_b((double)wp.x + 0.5, (double)wp.y + 1.0, (double)wp.z + 0.5, player.field_70177_z, player.field_70125_A);
    }

    public static void spawnTeleportParticles(double bX, double bY, double bZ, double x, double y, double z, float width, float height, World world) {
        int short1 = 128;
        Random rand = new Random();
        for (int i = 0; i < short1; ++i) {
            double d9 = (double)i / ((double)short1 - 1.0);
            float f = (rand.nextFloat() - 0.5f) * 0.2f;
            float f1 = (rand.nextFloat() - 0.5f) * 0.2f;
            float f2 = (rand.nextFloat() - 0.5f) * 0.2f;
            double d6 = bX + (x - bX) * d9 + (rand.nextDouble() - 0.5) * (double)width * 2.0;
            double d7 = bY + (y - bY) * d9 + rand.nextDouble() * (double)height;
            double d8 = bZ + (z - bZ) * d9 + (rand.nextDouble() - 0.5) * (double)width * 2.0;
            world.func_175688_a(EnumParticleTypes.PORTAL, d6, d7, d8, (double)f, (double)f1, (double)f2, new int[0]);
        }
    }

    public static Waypoint getPointingOrRandomWaypoint(Entity player, float minDistance) {
        Waypoint closestWP = ItemWaypointWand.getPointingWaypoint(player, minDistance);
        return closestWP;
    }

    public static Waypoint getPointingWaypoint(Entity player, float minDistance) {
        Waypoint closestWP = null;
        float closestDistance = -1.0f;
        for (int i = 0; i < CraftableWP.waypoints.size(); ++i) {
            ArrayList<Waypoint> l = CraftableWP.waypoints.get(i);
            for (int j = 0; j < l.size(); ++j) {
                Waypoint w = l.get(j);
                float distance = ItemWaypointWand.getCrosshairDistanceToWaypoint(w, player)[0];
                if (!(distance < minDistance) || closestDistance != -1.0f && !(distance < closestDistance)) continue;
                closestDistance = distance;
                closestWP = w;
            }
        }
        return closestWP;
    }

    public static float[] getCrosshairDistanceToWaypoint(Waypoint w, Entity player) {
        double offX = (double)w.x - player.field_70165_t + 0.5;
        double offY = (double)w.y - (player.field_70163_u + (double)player.func_70047_e()) + 1.0;
        double offZ = (double)w.z - player.field_70161_v + 0.5;
        double c = Math.sqrt(offX * offX + offZ * offZ);
        if (c == 0.0) {
            c = 0.001;
        }
        float angleY = ItemWaypointWand.getYawAngle(offX, offZ);
        float angleX = (float)Math.toDegrees(Math.atan(-offY / c));
        float cameraAngleY = MathHelper.func_76142_g((float)player.field_70177_z);
        float cameraAngleX = MathHelper.func_76142_g((float)player.field_70125_A);
        float distanceYaw = MathHelper.func_76142_g((float)(angleY - cameraAngleY));
        float distancePitch = MathHelper.func_76142_g((float)(angleX - cameraAngleX));
        return new float[]{(float)Math.sqrt(distanceYaw * distanceYaw + distancePitch * distancePitch), angleY};
    }

    public static float getYawAngleToWaypoint(Waypoint w, Entity player) {
        return ItemWaypointWand.getYawAngle((double)w.x - player.field_70165_t + 0.5, (double)w.z - player.field_70161_v + 0.5);
    }

    public static float getYawAngle(double offX, double offZ) {
        float Z = (float)(offZ == 0.0 ? 0.001 : offZ);
        float angleY = (float)Math.toDegrees(Math.atan(-offX / (double)Z));
        if (offZ < 0.0) {
            angleY = offX < 0.0 ? (angleY += 180.0f) : (angleY -= 180.0f);
        }
        return angleY;
    }
}

