/*
 * Decompiled with CFR 0.152.
 */
package craftwp;

import craftwp.CraftableWP;
import craftwp.PlayerWaypoints;
import craftwp.ServerWaypoint;
import craftwp.packets.CreatePacketServerSide;
import java.util.ArrayList;
import net.minecraft.block.BlockAir;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWaypoint
extends Item {
    public ItemWaypoint() {
        this.func_77625_d(64);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77655_b("waypoint");
        this.setRegistryName("xaerocraftwp:waypoint");
        this.func_77627_a(true);
    }

    protected String getPlayerName(EntityPlayer p, ItemStack stack) {
        return CraftableWP.allPublic || this.isPublicForced(stack) ? null : p.func_70005_c_();
    }

    public boolean isPublicForced(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("forcedPublic") && stack.func_77978_p().func_74767_n("forcedPublic");
    }

    public boolean freeTeleport(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("freeTeleport") && stack.func_77978_p().func_74767_n("freeTeleport");
    }

    public static boolean canBreak(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemWaypoint && stack.func_77942_o() && stack.func_77978_p().func_74764_b("breakable")) {
            return stack.func_77978_p().func_74767_n("breakable");
        }
        return true;
    }

    public static int getPearls(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("pearls")) {
            return stack.func_77978_p().func_74762_e("pearls");
        }
        return 0;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!(worldIn.func_180495_p(pos = pos.func_177971_a(this.directionVector(facing))).func_177230_c() instanceof BlockAir)) {
            return EnumActionResult.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            String name = stack.func_82833_r();
            PlayerWaypoints pw = CraftableWP.serverWaypoints.get(this.getPlayerName(player, stack));
            Object waypoints = pw.get(worldIn.field_73011_w.getSaveFolder());
            ServerWaypoint wp = new ServerWaypoint(pw.owner, ((ArrayList)waypoints).size(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), name, name.length() > 0 ? name.substring(0, 1) : " ", ItemWaypoint.waypointColour(stack), ItemWaypoint.canBreak(stack));
            wp.setTeleportAmount(ItemWaypoint.getPearls(stack));
            wp.freeTeleport = this.freeTeleport(stack);
            ((ArrayList)waypoints).add(wp);
            wp.updateWaypoint(worldIn);
            pw.setSaveNeeded(worldIn.field_73011_w.getSaveFolder(), true);
            CreatePacketServerSide.sendAddPacketToAll(worldIn, wp);
        }
        stack.func_190917_f(-1);
        return EnumActionResult.SUCCESS;
    }

    public Vec3i directionVector(EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return new Vec3i(0, -1, 0);
        }
        if (facing == EnumFacing.UP) {
            return new Vec3i(0, 1, 0);
        }
        if (facing == EnumFacing.NORTH) {
            return new Vec3i(0, 0, -1);
        }
        if (facing == EnumFacing.SOUTH) {
            return new Vec3i(0, 0, 1);
        }
        if (facing == EnumFacing.WEST) {
            return new Vec3i(-1, 0, 0);
        }
        if (facing == EnumFacing.EAST) {
            return new Vec3i(1, 0, 0);
        }
        return new Vec3i(0, 1, 0);
    }

    public static int waypointColour(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("colour")) {
            return stack.func_77978_p().func_74762_e("colour");
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        for (int i = 0; i < ItemDye.field_150922_c.length; ++i) {
            ItemStack sub = this.create(i, true, false, 0);
            subItems.add((Object)sub);
        }
    }

    public ItemStack create(int colour, boolean breakable, boolean freeTeleport, int pearls) {
        ItemStack sub = new ItemStack((Item)this, 1);
        sub.func_77982_d(new NBTTagCompound());
        sub.func_77978_p().func_74768_a("colour", colour);
        sub.func_77978_p().func_74757_a("breakable", breakable);
        sub.func_77978_p().func_74757_a("forcedPublic", false);
        sub.func_77978_p().func_74757_a("freeTeleport", freeTeleport);
        sub.func_77978_p().func_74768_a("pearls", pearls);
        return sub;
    }
}

