/*
 * Decompiled with CFR 0.152.
 */
package craftwp;

import craftwp.CraftableWP;
import craftwp.ItemWaypoint;
import craftwp.PlayerWaypoints;
import craftwp.ServerWaypoint;
import craftwp.TileWaypoint;
import craftwp.packets.CreatePacketServerSide;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class Events {
    static HashMap<EntityPlayerMP, String> updateMap = new HashMap();

    @SubscribeEvent
    public void joinEntity(EntityJoinWorldEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && event.getEntity() instanceof EntityPlayerMP) {
            updateMap.put((EntityPlayerMP)event.getEntity(), "");
            PlayerWaypoints publicPW = CraftableWP.serverWaypoints.get(null);
            PlayerWaypoints pw = CraftableWP.serverWaypoints.get(event.getEntity().func_70005_c_());
            if (((ArrayList)publicPW.get(event.getWorld().field_73011_w.getSaveFolder())).isEmpty()) {
                Events.loadWaypoints(event.getWorld(), null);
            }
            if (((ArrayList)pw.get(event.getWorld().field_73011_w.getSaveFolder())).isEmpty()) {
                Events.loadWaypoints(event.getWorld(), event.getEntity().func_70005_c_());
            }
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            EntityPlayerMP p = (EntityPlayerMP)event.player;
            String folder = p.func_130014_f_().field_73011_w.getSaveFolder();
            String dim = updateMap.get(p);
            if (folder == null && dim != null || folder != null && !folder.equals(dim)) {
                CreatePacketServerSide.sendClearPacketToClient(p);
                Events.sendWaypointsToPlayer(p, false, folder);
                Events.sendWaypointsToPlayer(p, true, folder);
                updateMap.put(p, folder);
            }
        }
    }

    @SubscribeEvent
    public void blockPlace(BlockEvent.PlaceEvent event) {
    }

    @SubscribeEvent
    public void breakPlace(BlockEvent.BreakEvent event) {
    }

    public static void sendWaypointsToPlayer(EntityPlayerMP p, boolean priv, String folder) {
        Object waypoints = CraftableWP.serverWaypoints.get(priv ? p.func_70005_c_() : null).get(folder);
        for (int i = 0; i < ((ArrayList)waypoints).size(); ++i) {
            CreatePacketServerSide.sendAddPacketToClient((ServerWaypoint)((ArrayList)waypoints).get(i), p);
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            Events.updateWaypoints(event.world);
        }
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        Iterator<PlayerWaypoints> iterator = CraftableWP.serverWaypoints.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().setLoadNeeded(event.getWorld().field_73011_w.getSaveFolder(), true);
        }
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getSide() != Side.SERVER) {
            return;
        }
        TileEntity tile = event.getWorld().func_175625_s(event.getPos());
        if (tile instanceof TileWaypoint) {
            TileWaypoint tilePoint = (TileWaypoint)tile;
            if (tilePoint.w == null) {
                event.setCanceled(true);
                return;
            }
            tilePoint.drop = !event.getEntityPlayer().func_184812_l_() || tilePoint.w.getTeleportAmount() > 0;
            event.setCanceled(tilePoint.w != null && (!tilePoint.w.canBeDestroyed && ItemWaypoint.canBreak(event.getEntityPlayer().func_184582_a(EntityEquipmentSlot.MAINHAND)) || tilePoint.w.owner != null && !event.getEntityPlayer().func_70005_c_().equals(tilePoint.w.owner)));
        }
    }

    public static String getSaveFileLocation(World w, String player) {
        String folder = w.field_73011_w.getSaveFolder();
        String toReturn = w.func_72860_G().func_75765_b() + (folder != null ? "/" + folder : "");
        if (player != null) {
            toReturn = toReturn + "/private waypoints/";
            new File(toReturn).mkdirs();
            toReturn = toReturn + player + ".txt";
        } else {
            toReturn = toReturn + "/xaerowaypoints.txt";
        }
        return toReturn;
    }

    private static void saveWaypoints(World w, String player) {
        try {
            PrintWriter writer = new PrintWriter(Events.getSaveFileLocation(w, player));
            Object waypoints = CraftableWP.serverWaypoints.get(player).get(w.field_73011_w.getSaveFolder());
            for (int i = 0; i < ((ArrayList)waypoints).size(); ++i) {
                ServerWaypoint wp = (ServerWaypoint)((ArrayList)waypoints).get(i);
                writer.println(wp.name + ":" + wp.symbol + ":" + wp.x + ":" + wp.y + ":" + wp.z + ":" + wp.color + ":" + wp.canBeDestroyed + ":" + wp.freeTeleport + ":" + wp.getTeleportAmount());
            }
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    private static void loadWaypoints(World w, String player) {
        ArrayList<ServerWaypoint> waypoints = new ArrayList<ServerWaypoint>();
        PlayerWaypoints pw = CraftableWP.serverWaypoints.get(player);
        pw.put(w.field_73011_w.getSaveFolder(), waypoints);
        pw.setSaveNeeded(w.field_73011_w.getSaveFolder(), false);
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(Events.getSaveFileLocation(w, player)));
            while ((line = reader.readLine()) != null) {
                String[] args = line.split(":");
                ServerWaypoint loadingWaypoint = new ServerWaypoint(pw.owner, w, Integer.parseInt(args[2]), Integer.parseInt(args[3]), Integer.parseInt(args[4]), args[0], args[1], Integer.parseInt(args[5]));
                if (args.length > 6) {
                    loadingWaypoint.canBeDestroyed = args[6].equals("true");
                }
                if (args.length > 7) {
                    loadingWaypoint.freeTeleport = args[7].equals("true");
                }
                if (args.length > 8) {
                    int amount = Integer.parseInt(args[8]);
                    loadingWaypoint.setTeleportAmount(amount);
                }
                waypoints.add(loadingWaypoint);
            }
            reader.close();
        }
        catch (FileNotFoundException reader) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public static void saveLoad(World w) {
        for (PlayerWaypoints pw : CraftableWP.serverWaypoints.values()) {
            if (pw.loadNeeded(w.field_73011_w.getSaveFolder())) {
                Events.loadWaypoints(w, pw.owner);
            }
            if (pw.saveNeeded(w.field_73011_w.getSaveFolder())) {
                Events.saveWaypoints(w, pw.owner);
            }
            pw.setSaveNeeded(w.field_73011_w.getSaveFolder(), false);
            pw.setLoadNeeded(w.field_73011_w.getSaveFolder(), false);
        }
    }

    public static void updateWaypoints(World world) {
        Iterator<PlayerWaypoints> iterator = CraftableWP.serverWaypoints.values().iterator();
        while (iterator.hasNext()) {
            Object waypoints = iterator.next().get(world.field_73011_w.getSaveFolder());
            if (waypoints == null) continue;
            for (int i = 0; i < ((ArrayList)waypoints).size(); ++i) {
                ((ServerWaypoint)((ArrayList)waypoints).get(i)).updateWaypoint();
            }
        }
    }
}

