/*
 * Decompiled with CFR 0.152.
 */
package craftwp;

import craftwp.BlockWaypoint;
import craftwp.ClientEvents;
import craftwp.Events;
import craftwp.ItemWaypoint;
import craftwp.ItemWaypointWand;
import craftwp.ServerEvents;
import craftwp.ServerWaypoints;
import craftwp.TileWaypoint;
import craftwp.Waypoint;
import craftwp.packets.ClientPacketHandler;
import craftwp.packets.ServerPacketHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import xaero.patreon.Patreon2;
import xaero.patreon.PatreonMod;

@Mod(modid="xaerocraftwp", name="Craftable Waypoints", version="1.3.1", acceptedMinecraftVersions="[1.11.2]")
public class CraftableWP {
    @Mod.Instance(value="xaerocraftwp")
    public static CraftableWP instance;
    public static String packetChannel;
    public static FMLEventChannel channel;
    public static File configFile;
    public static boolean allPublic;
    public static ServerWaypoints serverWaypoints;
    public static ArrayList<ArrayList<Waypoint>> waypoints;
    public static final Item waypointItem;
    public static final Item waypointWand;
    public static final Block waypointBlock;
    public static Events events;
    public static ClientEvents clientEvents;
    public static ServerEvents serverEvents;
    public static String fileLayout;
    public static String fileLayoutID;
    public static String latestVersion;

    public static void clearClientWaypoints() {
        waypoints.get(0).clear();
        waypoints.get(1).clear();
    }

    public static boolean clientWaypointsAreEmpty() {
        return waypoints.get(0).isEmpty() && waypoints.get(1).isEmpty();
    }

    public static PatreonMod getPatreon() {
        return Patreon2.mods.get(fileLayoutID);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) throws IOException {
        this.loadSettings();
        this.saveSettings();
        channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(packetChannel);
        channel.register((Object)new ServerPacketHandler());
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        GameRegistry.register((IForgeRegistryEntry)waypointItem);
        GameRegistry.register((IForgeRegistryEntry)waypointWand);
        GameRegistry.register((IForgeRegistryEntry)waypointBlock);
        GameRegistry.registerTileEntity(TileWaypoint.class, (String)"waypointTile");
        GameRegistry.addRecipe((ItemStack)((ItemWaypoint)waypointItem).create(1, true, false, 0), (Object[])new Object[]{" S ", "SRS", " S ", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('R'), Items.field_151137_ax});
        GameRegistry.addRecipe((ItemStack)new ItemStack(waypointWand, 1), (Object[])new Object[]{"  E", " S ", "B  ", Character.valueOf('S'), Items.field_151156_bN, Character.valueOf('B'), Items.field_151072_bj, Character.valueOf('E'), Items.field_151061_bv});
        for (int i = 0; i < ItemDye.field_150922_c.length; ++i) {
            GameRegistry.addShapelessRecipe((ItemStack)((ItemWaypoint)waypointItem).create(i, true, false, 0), (Object[])new Object[]{waypointItem, new ItemStack(Items.field_151100_aR, 1, i)});
        }
        events = new Events();
        if (side == Side.CLIENT) {
            Patreon2.checkPatreon();
            Patreon2.rendersCapes = fileLayoutID;
            waypoints.add(new ArrayList());
            waypoints.add(new ArrayList());
            channel.register((Object)new ClientPacketHandler());
            System.out.println("Loading client only events!");
            clientEvents = new ClientEvents();
            clientEvents.loadModels();
            MinecraftForge.EVENT_BUS.register((Object)clientEvents);
        }
        MinecraftForge.EVENT_BUS.register((Object)events);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (clientEvents == null) {
            System.out.println("Loading server only events!");
            serverEvents = new ServerEvents();
            MinecraftForge.EVENT_BUS.register((Object)serverEvents);
        }
    }

    public void loadSettings() {
        if (!configFile.exists()) {
            return;
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(configFile));
            while ((line = reader.readLine()) != null) {
                String[] args;
                if (line.startsWith("#") || !(args = line.split(":"))[0].equals("allPublic")) continue;
                allPublic = args[1].equals("true");
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveSettings() {
        try {
            PrintWriter writer = new PrintWriter(configFile);
            writer.println("#Restart the server for these to take effect!");
            writer.println("");
            writer.println("allPublic:" + allPublic);
            writer.println("#Newly placed waypoints are seen by anyone on the server. Previously placed private waypoints don't switch.");
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    static {
        packetChannel = "XaeroCraftWP";
        configFile = new File("./xaerocraftablewp.txt");
        allPublic = true;
        serverWaypoints = new ServerWaypoints();
        waypoints = new ArrayList();
        waypointItem = new ItemWaypoint();
        waypointWand = new ItemWaypointWand();
        waypointBlock = new BlockWaypoint();
        fileLayout = "Craftable_Waypoints_&mod_Forge_&mc.jar";
        fileLayoutID = "craftablewp";
    }
}

