/*
 * Decompiled with CFR 0.152.
 */
package craftwp;

import craftwp.Animation;
import craftwp.CraftableWP;
import craftwp.Events;
import craftwp.ItemWaypoint;
import craftwp.ItemWaypointWand;
import craftwp.Waypoint;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;
import xaero.patreon.Patreon2;

public class ClientEvents {
    public static Minecraft mc = Minecraft.func_71410_x();
    public static BlockPos teleportSound = null;
    private static int clientTicker = 0;
    public static final DecimalFormat simpleFormat = new DecimalFormat("0.0");
    public static double teleportScaler1 = 1.7;
    public static double teleportScaler2 = 2.0;

    public void loadModels() {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(CraftableWP.waypointItem, 0, new ModelResourceLocation("xaerocraftwp:waypoint", "inventory"));
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return ItemDye.field_150922_c[ItemWaypoint.waypointColour(stack)];
            }
        }, new Item[]{CraftableWP.waypointItem});
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(CraftableWP.waypointWand, 0, new ModelResourceLocation("xaerocraftwp:wand", "inventory"));
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)CraftableWP.waypointBlock), 0, new ModelResourceLocation("xaerocraftwp:waypointBlock", "inventory"));
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (teleportSound != null) {
            ClientEvents.mc.field_71441_e.func_184133_a((EntityPlayer)ClientEvents.mc.field_71439_g, teleportSound, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
            teleportSound = null;
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (mc.func_71401_C() != null) {
            for (WorldServer worldServer : ClientEvents.mc.func_71401_C().field_71305_c) {
                Events.saveLoad((World)worldServer);
            }
        } else if (ClientEvents.mc.field_71441_e == null && !CraftableWP.clientWaypointsAreEmpty()) {
            CraftableWP.clearClientWaypoints();
        }
        if (ClientEvents.mc.field_71441_e != null && clientTicker > 5) {
            clientTicker = 0;
            for (int i = 0; i < 2; ++i) {
                ArrayList<Waypoint> wps = CraftableWP.waypoints.get(i);
                if (wps == null) continue;
                for (int j = 0; j < wps.size(); ++j) {
                    Waypoint waypoint = wps.get(j);
                    if (waypoint == null) continue;
                    waypoint.updateBeamHeight((World)ClientEvents.mc.field_71441_e);
                }
            }
        }
        ++clientTicker;
    }

    @SubscribeEvent
    public void renderLast(RenderWorldLastEvent event) {
        if (!CraftableWP.clientWaypointsAreEmpty()) {
            Entity entity = mc.func_175606_aa();
            double d3 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)event.getPartialTicks();
            double d4 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)event.getPartialTicks();
            double d5 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)event.getPartialTicks();
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer vertexBuffer = tessellator.func_178180_c();
            ClientEvents.renderWaypoints(0, d3, d4, d5, entity, vertexBuffer, tessellator);
            ClientEvents.renderWaypoints(1, d3, d4, d5, entity, vertexBuffer, tessellator);
            RenderHelper.func_74518_a();
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            Animation.tick();
        }
    }

    public static void renderWaypoints(int category, double d3, double d4, double d5, Entity entity, VertexBuffer vertexBuffer, Tessellator tessellator) {
        ArrayList<Waypoint> waypoints = CraftableWP.waypoints.get(category);
        Waypoint pointing = ItemWaypointWand.getPointingWaypoint(entity, 30.0f);
        for (int i = 0; i < waypoints.size(); ++i) {
            Waypoint w = waypoints.get(i);
            if (w == null) continue;
            ClientEvents.renderIngameWaypoint(w, 12.0, d3, d4, d5, entity, vertexBuffer, tessellator, pointing);
        }
    }

    protected static void renderIngameWaypoint(Waypoint w, double radius, double d3, double d4, double d5, Entity entity, VertexBuffer vertexBuffer, Tessellator tessellator, Waypoint pointing) {
        double dest;
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        FontRenderer fontrenderer = renderManager.func_78716_a();
        if (fontrenderer == null) {
            return;
        }
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        GlStateManager.func_179094_E();
        float offX = (float)w.x - (float)d3 + 0.5f;
        float offY = (float)w.y - (float)d4 + 1.0f;
        float offZ = (float)w.z - (float)d5 + 0.5f;
        double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
        float textSize = 1.0f;
        boolean background = false;
        String name = w.getName();
        boolean showDistance = false;
        boolean teleport = false;
        if (w.justPlaced || w == pointing && entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184587_cr() && (((EntityPlayer)entity).func_184582_a(EntityEquipmentSlot.MAINHAND) != null && ((EntityPlayer)entity).func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() instanceof ItemWaypointWand || ((EntityPlayer)entity).func_184582_a(EntityEquipmentSlot.OFFHAND) != null && ((EntityPlayer)entity).func_184582_a(EntityEquipmentSlot.OFFHAND).func_77973_b() instanceof ItemWaypointWand)) {
            dest = w.teleportScaleUp ? teleportScaler2 : teleportScaler1;
            teleport = true;
        } else {
            w.teleportScaleUp = true;
            dest = 1.0;
        }
        double diff = w.teleportScale - dest;
        diff = Animation.animate(diff, w.teleportScaleUp ? 0.9 : 0.95);
        if (w.justPlaced && Math.abs(diff) < 0.6) {
            w.justPlaced = false;
            teleport = false;
        }
        if (teleport && diff < 0.1 && diff > -0.1) {
            w.teleportScaleUp = !w.teleportScaleUp;
        }
        w.teleportScale = dest + diff;
        float zoomer2 = 1.0f;
        float zoomer = 1.0f;
        float[] crosshairDistanceAndAngle = ItemWaypointWand.getCrosshairDistanceToWaypoint(w, entity);
        float realAngleToWP = crosshairDistanceAndAngle[1];
        if (distance > radius) {
            double maxDistance = (double)Minecraft.func_71410_x().field_71474_y.field_151451_c * 16.0;
            if (distance > maxDistance) {
                zoomer2 = (float)(maxDistance / radius);
                zoomer = (float)(maxDistance / distance);
            } else {
                zoomer2 = (float)(distance / radius);
            }
            if (distance > 20.0) {
                textSize = 1.6f;
                float crosshairDistance = crosshairDistanceAndAngle[0];
                boolean bl = showDistance = crosshairDistance > -20.0f && crosshairDistance < 20.0f;
                if (showDistance) {
                    name = simpleFormat.format(distance) + "m";
                    background = true;
                } else {
                    name = "";
                }
            }
        }
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)offX, (float)offY, (float)offZ);
        if (ClientEvents.mc.field_71474_y.field_74320_O != 0) {
            GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GlStateManager.func_179114_b((float)(-realAngleToWP), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        w.drawBeamInWorld(vertexBuffer, tessellator, Math.sqrt(offX * offX + offZ * offZ), (double)offY - 1.0 >= (double)entity.field_70131_O ? -1 : ((double)(w.y + w.beamHeight) < entity.field_70163_u + (double)entity.func_70047_e() ? 1 : 0));
        GlStateManager.func_179121_F();
        GlStateManager.func_179109_b((float)(offX * zoomer), (float)(offY * zoomer + entity.func_70047_e() * (1.0f - zoomer)), (float)(offZ * zoomer));
        GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(renderManager.field_78732_j * (float)(ClientEvents.mc.field_71474_y.field_74320_O == 2 ? -1 : 1)), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
        GlStateManager.func_179152_a((float)zoomer2, (float)zoomer2, (float)1.0f);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179139_a((double)(2.0 * w.teleportScale), (double)(2.0 * w.teleportScale), (double)1.0);
        w.drawIconInWorld(vertexBuffer, tessellator, fontrenderer, name, textSize, background, showDistance);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Post event) {
        Patreon2.renderCape(CraftableWP.fileLayoutID, event);
    }
}

