/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMIButton
extends TMIArea {
    public String label;
    public Object data;
    public amj stack = null;
    public boolean showState = false;
    public boolean state = false;
    public int textScale = 2;
    public boolean centerText = true;
    public boolean itemTooltip = false;

    public TMIButton(Object object, String string, amj amj2) {
        this.data = object;
        this.label = string;
        this.stack = amj2;
        this.setOwnWidth();
        this.height = amj2 != null ? 16 : 12;
    }

    public TMIButton(Object object, String string) {
        this(object, string, null);
    }

    public TMIButton() {
        this(null, "");
    }

    public TMIButton item(String string) {
        this.stack = new TMIStackBuilder(string).stack();
        return this;
    }

    public TMIButton item(String string, int n) {
        this.stack = new TMIStackBuilder(string).meta(n).stack();
        return this;
    }

    public TMIButton center(boolean bl) {
        this.centerText = bl;
        return this;
    }

    public void setOwnWidth() {
        this.width = TMIDrawing.getTextWidth(this.label, this.textScale) + this.graphicWidth() + this.getMargin();
    }

    public int graphicWidth() {
        return this.stack != null ? 18 : 0;
    }

    public int getMargin() {
        if (this.label != null && this.label.length() > 0) {
            return 6;
        }
        return 2;
    }

    protected boolean drawGraphic(int n) {
        if (this.stack != null) {
            int n2 = this.y + (this.height - 16) / 2;
            TMIDrawing.drawItem(n, n2, this.stack);
            return true;
        }
        return false;
    }

    @Override
    public void drawComponent(int n, int n2) {
        TMIDrawing.fillRect(this.x, this.y, this.width, this.height, this.contains(n, n2) ? 0x22FFFFFF : 0);
        TMIDrawing.drawText(this.x, this.y, "", -1);
        String string = this.label;
        int n3 = TMIDrawing.getTextWidth(string, this.textScale);
        int n4 = this.graphicWidth();
        while (n3 + n4 > this.width && string.length() > 0) {
            string = string.substring(0, string.length() - 1);
            n3 = TMIDrawing.getTextWidth(string, this.textScale);
        }
        int n5 = n3 + n4;
        int n6 = this.x + this.getMargin();
        if (this.centerText) {
            n6 = this.x + (this.width - n5) / 2;
        }
        int n7 = this.y + (this.height - 8) / 2;
        boolean bl = this.drawGraphic(n6);
        n6 += this.graphicWidth();
        if (bl && n3 > 0) {
            n6 += 2;
        }
        TMIDrawing.drawText(n6, n7, string, -1, this.textScale);
    }

    @Override
    public List<String> getTooltip() {
        if (this.itemTooltip && this.stack != null) {
            return this.stack.a((ahd)bsu.z().h, true);
        }
        return null;
    }
}

